** Script to compile the gallup trust data
cd "data"
set more off
clear *

label define trust 1 "A GREAT DEAL" 2 "QUITE A LOT" 3 "SOME" 4 "VERY LITTLE" 5 "NONE"
label define states 58 "AL" 85 "AK" 72 "AZ" 61 "AR" 81 "CA" 73 "CO" 16 "CT" 25 "DE" 27 "DC" 55 "FL" 54 "GA" 84 "HI" 74 "ID" 34 "IL" 33 "IN" 43 "IA" 48 "KS" 56 "KY" 62 "LA" 11 "ME" 24 "MD" 14 "MA" 32 "MI" 42 "MN" 59 "MS" 44 "MO" 71 "MT" 47 "NE" 77 "NV" 12 "NH" 22 "NJ" 78 "NM" 21 "NY" 52 "NC" 45 "ND" 31 "OH" 63 "OK" 82 "OR" 23 "PA" 15 "RI" 53 "SC" 46 "SD" 57 "TN" 64 "TX" 76 "UT" 13 "VT" 51 "VA" 83 "WA" 26 "WV" 41 "WI" 75 "WY"
label define education 1 "None or grade 1 - 4" 2 "Grade 5 6 or 7" 3 "Grade 8" 4 "High school incomplete (Grades 9 - 11)" 5 "High school graduate Grade 12" 6 "Technical trade or business after high school" 7 "College/university incomplete" 8 "College/university graduate or more"
label define genders 0 "Male" 1 "Female"
label define racelabels 1 "White" 2 "Black" 3 "Hispanic" 4 "Asian" 5 "American Indian" 6 "Pacific Islander" 7 "Other Race"

infix 2 lines weight 2:74-74 sex 2:69-69 state 2:72-73 church 2:38 supcourt 2:34 schools 2:32 newspapers 2:36 congress 2:35 tv 2:37 labor 2:33 bigbus 2:39 educ 2:65 age 2:66-67 race 2:69-69 using 870.dat, clear
gen date=mdy(5,7,1973)
label values educ education
label values state states
foreach var of varlist church supcourt schools newspapers congress tv labor bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (2=1) (3 4=2) (5 6=7)
label values race racelabels

save gallup1973-05, replace



infix 1 lines weight 1:56-56 sex 1:51-51 state 1:54-55 church 1:36 military 1:35 supcourt 1:26 congress 1:25 labor 1:30 presidency 1:27 bigbus 1:37 educ 1:47 age 1:48-49 race 1:51-51 using 930.dat, clear
gen date=mdy(6,2,1975)
label values educ education
label values state states
foreach var of varlist church military supcourt congress labor presidency bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (2=1) (3 4=2) (5 6=7)
label values race racelabels

save gallup1975-06, replace



infix 1 lines weight 1:1-1 sex 1:33-33 state 1:40-41 church 1:18 military 1:21 supcourt 1:16 schools 1:23 congress 1:17 labor 1:19 bigbus 1:20 educ 1:28 age 1:29-30 race 1:32-32 using 965.dat, clear
gen date=mdy(1,10,1977)
label values educ education
label values state states
foreach var of varlist church military supcourt schools congress labor bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
label values race racelabels

save gallup1977-01, replace



infix 1 lines weight 1:1-1 sex 1:58-58 state 1:84-85 church 1:21 military 1:24 supcourt 1:19 banks 1:26 schools 1:25 newspapers 1:28 congress 1:20 tv 1:27 labor 1:22 bigbus 1:23 educ 1:50 age 1:51-52 race 1:57-57 using 1127.dat, clear
gen date=mdy(4,9,1979)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tv labor bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
label values race racelabels

save gallup1979-04, replace



infix 1 lines weight 1:1-1 sex 1:66-66 state 1:77-78 church 1:13 military 1:15 supcourt 1:18 banks 1:14 schools 1:16 newspapers 1:17 congress 1:21 tv 1:19 labor 1:20 bigbus 1:22 educ 1:59 age 1:61-62 race 1:65-65 using 1186.dat, clear
gen date=mdy(11,23,1981)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tv labor bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
label values race racelabels

save gallup1981-11, replace



infix 1 lines weight 1:1-1 sex 1:53-53 state 1:64-65 church 1:12 military 1:14 supcourt 1:17 banks 1:13 schools 1:15 newspapers 1:16 congress 1:20 tv 1:18 labor 1:19 bigbus 1:21 educ 1:49 age 1:23-24 race 1:52-52 using 1220.dat, clear
gen date=mdy(8,8,1983)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tv labor bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
label values race racelabels

save gallup1983-08, replace



infix 1 lines weight 1:1-3 sex 1:120-120 state 1:130-131 church 1:9 military 1:10 supcourt 1:12 banks 1:11 schools 1:13 newspapers 1:14 congress 1:15 tv 1:18 labor 1:17 bigbus 1:16 educ 1:115 age 1:116-117 race 1:119-119 using 84218.dat, clear
gen date=mdy(10,10,1984)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tv labor bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
replace race=. if race==0
label values race racelabels
replace weight = weight/100
save gallup1984-10, replace



infix 1 lines weight 1:5-7 sex 1:114-114 state 1:125-126 church 1:71 military 1:73 supcourt 1:76 banks 1:72 schools 1:74 newspapers 1:75 congress 1:79 tv 1:77 labor 1:78 bigbus 1:80 educ 1:107 age 1:108-109 race 1:115-115 using 1253.dat, clear
gen date=mdy(5,20,1985)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tv labor bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
label values race racelabels
replace weight = weight/100
save gallup1985-05, replace



infix 1 lines weight 1:1-3 sex 1:183-183 state 1:194-195 church 1:128 military 1:130 supcourt 1:133 banks 1:129 schools 1:131 newspapers 1:132 congress 1:136 tv 1:134 labor 1:135 bigbus 1:137 educ 1:176 age 1:177-178 race 1:184-184 using 1266.dat, clear
gen date=mdy(7,14,1986)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tv labor bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
label values race racelabels
replace weight = weight/100
save gallup1986-07, replace



infix 1 lines weight 1:1-3 sex 1:154-154 state 1:165-166 church 1:96 supcourt 1:98 newspapers 1:97 congress 1:99 educ 1:147 age 1:148-149 race 1:155-155 using 1269.dat, clear
gen date=mdy(10,27,1986)
label values educ education
label values state states
foreach var of varlist church supcourt newspapers congress {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
label values race racelabels
replace weight = weight/100
save gallup1986-10, replace



infix 1 lines weight 1:5-7 sex 1:213-213 state 1:225-226 church 1:117 military 1:119 supcourt 1:122 banks 1:118 schools 1:120 newspapers 1:121 tv 1:123 labor 1:124 educ 1:206 age 1:207-208 race 1:214-214 using 1278.DAT, clear
gen date=mdy(7,13,1987)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers tv labor {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
label values race racelabels
replace weight = weight/100
save gallup1987-07, replace



infix 9 lines weight 1:11-13 sex 1:83-83 state 1:107-108 church 2:34 military 2:40 congress 2:41 labor 2:42 bigbus 2:43 educ 1:79 age 1:80-81 race 1:83-83 using GIVE88.DAT, clear
gen date=mdy(3,18,1988)
label values educ education
label values state states
foreach var of varlist church military congress labor bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (2=1) (3 4=2) (5 6=7)
replace race=.d if race==0
label values race racelabels
replace weight = weight/100
save gallup1988-03, replace



infix 4 lines weight 1:13-15 sex 1:44-44 state 1:78-79 church 3:25 military 3:26 supcourt 3:27 banks 3:28 schools 3:29 newspapers 3:30 congress 3:31 tv 3:32 labor 3:33 bigbus 3:34 educ 1:47 age 1:45-46 race 1:48-48 using g922016.dat, clear
gen date=mdy(8,19,1990)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tv labor bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
replace race=.d if race==4
label values race racelabels
replace weight = weight/100
save gallup1990-08, replace



infix 3 lines weight 1:13-15 sex 1:44-44 state 1:78-79 church 3:39 military 3:40 supcourt 3:41 banks 3:42 schools 3:43 newspapers 3:44 congress 3:45 tv 3:46 labor 3:47 presidency 3:49 bigbus 3:48 educ 1:47 age 1:45-46 race 1:48-48 using G122019.DAT, clear
gen date=mdy(3,3,1991)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tv labor presidency bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
replace race=.d if race==4
replace race=.r if race==5
label values race racelabels
replace weight = weight/100
save gallup1991-03, replace



infix 4 lines weight 1:13-15 sex 1:44-44 state 1:78-79 church 3:29 military 3:30 supcourt 3:31 banks 3:32 schools 3:33 newspapers 3:34 congress 3:35 tv 3:36 labor 3:37 presidency 3:39 bigbus 3:38 educ 1:47 age 1:45-46 race 1:48-48 using G222019.DAT, clear
gen date=mdy(10,13,1991)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tv labor presidency bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=4) (4=7)
replace race=.d if race==5
replace race=.r if race==6
label values race racelabels
replace weight = weight/100
save gallup1991-10, replace



infix 5 lines weight 1:13-15 sex 1:44-44 state 1:78-79 church 5:23 military 5:24 supcourt 5:25 banks 5:26 schools 5:27 newspapers 5:28 congress 5:29 tvnews 5:31 tv 5:30 labor 5:32 presidency 5:34 police 5:35 medicine 5:36 justice 5:37 bigbus 5:33 educ 1:47 age 1:45-46 race 1:48-48 using A322052.DAT, clear
gen date=mdy(3,24,1993)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews tv labor presidency police medicine justice bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=4) (4=7)
replace race=.d if race==5
replace race=.r if race==6
label values race racelabels
replace weight = weight/100
save gallup1993-03, replace



infix 6 lines weight 1:13-15 sex 1:44-44 state 1:78-79 church 5:40 military 5:41 supcourt 5:42 banks 5:43 schools 5:44 newspapers 5:45 congress 5:46 tvnews 5:47 labor 5:48 presidency 5:50 police 5:51 medicine 5:52 justice 5:53 bigbus 5:49 educ 1:47 age 1:45-46 race 6:76-77 using A422039.DAT, clear
gen date=mdy(3,27,1994)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1994-03, replace



infix 7 lines weight 1:13-15 sex 1:44-44 state 1:78-79 church 5:23 military 5:24 supcourt 5:25 banks 5:26 schools 5:27 newspapers 5:28 congress 5:29 tvnews 5:30 labor 5:31 presidency 5:33 police 5:34 medicine 5:35 justice 5:36 bigbus 5:32 educ 1:47 age 1:45-46 race 6:76-77 using A018A.DAT, clear
gen date=mdy(4,24,1995)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1995-04, replace



infix 9 lines weight 1:13-15 sex 1:44-44 state 1:78-79 church 5:27 military 5:28 supcourt 5:29 banks 5:30 schools 5:31 newspapers 5:32 congress 5:33 tvnews 5:34 labor 5:35 presidency 5:37 police 5:38 medicine 5:39 justice 5:40 bigbus 5:36 educ 1:47 age 1:45-46 race 6:76-77 using A9605012.DAT, clear
gen date=mdy(5,29,1996)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1996-05, replace



infix 7 lines weight 1:13-15 sex 1:44-44 state 1:78-79 church 6:25 military 6:26 supcourt 6:27 banks 6:28 schools 6:29 newspapers 6:30 congress 6:31 tvnews 6:32 labor 6:33 presidency 6:34 police 6:35 medicine 6:36 justice 6:37 bigbus 6:38 smallbus 6:39 educ 1:47 age 1:45-46 race 5:14-15 using g9707017.DAT, clear
gen date=mdy(7,27,1997)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus smallbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1997-07, replace



infix 7 lines weight 1:13-15 sex 1:44-44 state 1:78-79 church 6:28 military 6:29 supcourt 6:30 banks 6:31 schools 6:32 newspapers 6:33 congress 6:34 tvnews 6:35 labor 6:36 presidency 6:37 police 6:38 medicine 6:39 justice 6:40 bigbus 6:41 smallbus 6:42 educ 1:47 age 1:45-46 race 5:14-15 using A9806017.DAT, clear
gen date=mdy(6,7,1998)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus smallbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1998-06, replace



infix 7 lines weight 1:13-15 sex 1:44-44 state 1:78-79 church 6:47 schools 6:48 labor 6:53 justice 6:49 bigbus 6:54 educ 1:47 age 1:45-46 race 5:14-15 using A9807019.DAT, clear
gen date=mdy(7,8,1998)
label values educ education
label values state states
foreach var of varlist church schools labor justice bigbus {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1998-07, replace



infix 7 lines weight 1:13-15 sex 1:44-44 state 1:78-79 church 6:38 military 6:39 supcourt 6:40 banks 6:41 schools 6:42 newspapers 6:43 congress 6:44 tvnews 6:45 labor 6:46 presidency 6:47 police 6:48 medicine 6:49 justice 6:50 bigbus 6:51 hmos 6:54 educ 1:47 age 1:45-46 race 5:14-15 using A9906032.DAT, clear
gen date=mdy(6,27,1999)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1999-06, replace



infix 1 lines weight 1:7-10 sex 1:57-57 state 1:14-15 military 1:96 supcourt 1:97 congress 1:98 tvnews 1:100 presidency 1:99 educ 1:60 age 1:58-59 race 1:63-64 using 56nat.dat, clear
gen date=mdy(12,17,2000)
label values educ education
label values state states
foreach var of varlist military supcourt congress tvnews presidency {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2000-12, replace



infix 1 lines weight 1:7-10 sex 1:43-43 state 1:13-14 church 1:84 military 1:85 supcourt 1:86 banks 1:87 schools 1:88 newspapers 1:89 congress 1:90 tvnews 1:91 labor 1:92 presidency 1:93 police 1:94 medicine 1:95 justice 1:96 bigbus 1:97 hmos 1:98 educ 1:49 age 1:47-48 race 1:52-53 using g200025.dat, clear
gen date=mdy(6,25,2000)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels

save gallup2000-06, replace



infix 1 lines weight 1:7-10 sex 1:56-56 state 1:13-14 church 1:92 military 1:93 supcourt 1:94 banks 1:95 schools 1:96 newspapers 1:97 congress 1:98 tvnews 1:99 labor 1:100 presidency 1:101 police 1:102 medicine 1:103 bigbus 1:104 hmos 1:105 educ 1:59 age 1:57-58 race 1:62-63 using a200121.dat, clear
gen date=mdy(6,10,2001)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine bigbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2001-06, replace



infix 1 lines weight 1:7-10 sex 1:66-66 state 1:13-14 church 1:105 military 1:106 supcourt 1:107 banks 1:108 schools 1:109 newspapers 1:110 congress 1:111 tvnews 1:112 labor 1:113 presidency 1:114 police 1:115 medicine 1:116 justice 1:117 bigbus 1:118 hmos 1:119 educ 1:69 age 1:67-68 race 1:72-73 using 2002_06_21x.dat, clear
gen date=mdy(6,23,2002)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2002-06, replace



infix 1 lines weight 1:7-10 sex 1:68-68 state 1:13-14 church 1:105 military 1:106 supcourt 1:107 banks 1:108 schools 1:109 newspapers 1:110 congress 1:111 tvnews 1:112 labor 1:113 presidency 1:114 police 1:115 medicine 1:116 justice 1:117 bigbus 1:118 hmos 1:119 educ 1:71 age 1:69-70 race 1:74-75 using 2003_06_09x.dat, clear
gen date=mdy(6,10,2003)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2003-06, replace



infix 1 lines weight 1:7-10 sex 1:75-75 state 1:13-14 church 1:121 military 1:122 supcourt 1:123 banks 1:124 schools 1:125 newspapers 1:126 congress 1:127 tvnews 1:128 labor 1:129 presidency 1:130 police 1:131 medicine 1:132 justice 1:133 bigbus 1:134 hmos 1:135 educ 1:78 age 1:76-77 race 1:81-82 using g200418.dat, clear
gen date=mdy(5,23,2004)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2004-05, replace



infix 1 lines weight 1:7-10 sex 1:75-75 state 1:13-14 church 1:118 military 1:119 supcourt 1:120 banks 1:121 schools 1:122 newspapers 1:123 congress 1:124 tvnews 1:125 labor 1:126 presidency 1:127 police 1:128 medicine 1:129 justice 1:130 bigbus 1:131 hmos 1:132 educ 1:78 age 1:76-77 race 1:81-82 using g200524.dat, clear
gen date=mdy(5,26,2005)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3) (9=4) (10=5)
label values race racelabels

save gallup2005-05, replace



infix 1 lines weight 1:9-12 sex 1:77-77 state 1:15-16 church 1:139 military 1:140 supcourt 1:141 banks 1:142 schools 1:143 newspapers 1:144 congress 1:145 tvnews 1:146 labor 1:147 presidency 1:148 police 1:149 medicine 1:150 justice 1:151 bigbus 1:152 hmos 1:153 educ 1:80 age 1:78-79 race 1:83-84 using g200621.dat, clear
gen date=mdy(6,4,2006)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2006-06, replace



infix 1 lines weight 1:5-8 sex 1:122-122 state 1:11-12 church 1:57 military 1:58 supcourt 1:59 banks 1:60 schools 1:61 newspapers 1:62 congress 1:63 tvnews 1:64 labor 1:65 presidency 1:66 police 1:67 medicine 1:68 justice 1:69 bigbus 1:70 smallbus 1:71 hmos 1:72 educ 1:125 age 1:123-124 race 1:128-129 using a200721.dat, clear
gen date=mdy(6,14,2007)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus smallbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
recode race (1=7) (6=1) (7=2) (8=3) (9=4) (10=5)
label values race racelabels

save gallup2007-06, replace



infix 1 lines weight 1:7-10 sex 1:69-69 state 1:11-12 church 1:153 military 1:154 supcourt 1:155 banks 1:156 schools 1:157 newspapers 1:158 congress 1:159 tvnews 1:160 labor 1:161 presidency 1:162 police 1:163 medicine 1:164 justice 1:165 bigbus 1:166 smallbus 1:167 hmos 1:168 educ 1:72 age 1:70-71 white 1:75 black 1:76 other1 1:77-78 other2 1:79-80 using g200824.dat, clear
gen date=mdy(6,12,2008)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus smallbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
gen race=1 if white==1
replace race=2 if black==1 & race==.
replace race=3 if race==. & (other1==20 | other2==20)
replace race=4 if race==. & (other1==6 | other2==6)
replace race=5 if race==. & (other1==7 | other2==7)
replace race=6 if race==. & (other1==8 | other2==8)
replace race=7 if race==. & (other1==1 | other2==1)
drop white black other1 other2
label values race racelabels

save gallup2008-06, replace



infix 1 lines weight 1:7-10 sex 1:67-67 state 1:11-12 church 1:134 military 1:135 supcourt 1:136 banks 1:137 schools 1:138 newspapers 1:139 congress 1:140 tvnews 1:141 labor 1:142 presidency 1:143 police 1:144 medicine 1:145 justice 1:146 bigbus 1:147 smallbus 1:148 hmos 1:149 educ 1:70 age 1:68-69 white 1:73 black 1:74 other1 1:75-76 other2 1:77-78 using g200911.dat, clear
gen date=mdy(6,17,2009)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus smallbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
gen race=1 if white==1
replace race=2 if black==1 & race==.
replace race=3 if race==. & (other1==20 | other2==20)
replace race=4 if race==. & (other1==6 | other2==6)
replace race=5 if race==. & (other1==7 | other2==7)
replace race=6 if race==. & (other1==8 | other2==8)
replace race=7 if race==. & (other1==1 | other2==1)
drop white black other1 other2
label values race racelabels

save gallup2009-06, replace



infix 1 lines weight 1:7-10 sex 1:67-67 state 1:11-12 church 1:134 military 1:135 supcourt 1:136 banks 1:137 schools 1:138 newspapers 1:139 congress 1:140 tvnews 1:141 labor 1:142 presidency 1:143 police 1:144 medicine 1:145 justice 1:146 bigbus 1:147 smallbus 1:148 hmos 1:149 educ 1:70 age 1:68-69 white 1:73 black 1:74 other1 1:75-76 other2 1:77-78 using g201009.dat, clear
gen date=mdy(7,11,2010)
label values educ education
label values state states
foreach var of varlist church military supcourt banks schools newspapers congress tvnews labor presidency police medicine justice bigbus smallbus hmos {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.d if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
gen race=1 if white==1
replace race=2 if black==1 & race==.
replace race=3 if race==. & (other1==20 | other2==20)
replace race=4 if race==. & (other1==6 | other2==6)
replace race=5 if race==. & (other1==7 | other2==7)
replace race=6 if race==. & (other1==8 | other2==8)
replace race=7 if race==. & (other1==1 | other2==1)
drop white black other1 other2
label values race racelabels

save gallup2010-07, replace

use gallup2010-07, clear
gen str20 survey="gallup2010-07"
for X in any 2009-06 2008-06 2007-06 2006-06 2005-05 2004-05 2003-06 2002-06 2001-06 2000-12 2000-06 1999-06 1998-07 1998-06 1997-07 1996-05 1995-04 1994-03 1993-03 1991-10 1991-03 1990-08 1988-03 1987-07 1986-10 1986-07 1985-05 1984-10 1983-08 1981-11 1979-04 1977-01 1975-06 1973-05: append using "gallupX" \ replace survey="gallupX" if survey==""
cd ..
save gallup_public_trust.dta, replace
